/**
 * SIMPLIFIED VERSION, Adapted by John Park
 * osc, processing and the wiimote, using darwiinremoteOSC
 * for comments or questions contact andreas schlegel, andi@sojamo.de
 */
 


WiiController wiiController;


//GL gl; 
//PGraphicsOpenGL pgl;

float w = 400;
float h = 400;
float wn = 400;
float hn = 400;
float newH = 100;
float newW = 100;
float newHn = 100;
float newWn = 100;


int ledCnt = 0;
  
void setup() {
  size(800,600, P3D);
 // pgl = (PGraphicsOpenGL)g;
  //gl = pgl.gl;
  frameRate(25);
  noStroke();
  //smooth();
  wiiController = new WiiController();
  rectMode(CENTER);
}

void mousePressed() {
  // check the battery level of the wii controller
  wiiController.requestBatterylevel();
  
  // turn force feedback of the wii controller off 
  //wiiController.forcefeedback(true);
  
}

void keyPressed() {
  // turn forc feedback of the wii controller on
  //wiiController.oscP5.send("/wii/forcefeedback",new Object[] {new Integer(1)},"127.0.0.1",5601);
  ledCnt++;
  ledCnt %=4;
  int[] t = new int[] {
    0,0,0,0  };
    t[ledCnt] = 1;    
    wiiController.led(t);

}


void draw() {
  //pgl.beginGL();
  //gl.glDisable(GL.GL_DEPTH_TEST);
  //gl.glEnable (GL.GL_BLEND);
  //gl.glBlendFunc (GL.GL_SRC_ALPHA , GL.GL_ONE);
  //pgl.endGL(); 
  background(0);
  fill(255,32);
  if(wiiController.buttonB) {
    ellipse(0, 0, 50,50);
  }  else {
   // newW = 40;
   // newH = 40;
  }
  
  if(wiiController.buttonZ) {
    newWn = 600;
    newHn = 300;
  } else {
    newWn = 40;
    newHn = 40;
  } 
 
  w += (newW-w)*0.04;
  h += (newH-h)*0.04;
  
  wn += (newWn-wn)*0.04;
  hn += (newHn-hn)*0.04;
  pushMatrix();
  translate(width/2,height/2,0);
  
  for(int i=0;i<20;i++) {
    pushMatrix();
    rotateY(wiiController.roll/(7.0+i*4));
    rotateX(wiiController.pitch/(7.0+i*4));
    fill(24,222,88,100);
    ellipse(width/2,height/2,w+i*10,h+i*10);
    popMatrix();
  }
  popMatrix();
  

}
