float grow = 0;
int count = 300;
color [] armColors = new color [count];
color [] palette = {#3D77A6, #B5D932, #A1BF36, #F26849, #89F2AD};
float [] sizes = new float [count];

float [] rotX = new float [count];
float [] rotY = new float [count];
float [] rotZ = new float [count];

void setup(){
  size(displayWidth, displayHeight, P3D); 
  rectMode(CENTER);
  noCursor();
  for (int t=0; t<count; t++){
    armColors[t] = palette[int(random(5))];
    sizes[t] = random(15, 25);
    rotX[t] = random(360);
    rotY[t] = random(360);
    rotZ[t] = random(360);
  }
}


void draw(){
  grow += .009; // This affects speed of sin wav.
  float wavy = abs(sin(grow))*300; // Sine wave motion. grow affect speed, abs makes neg > positive, *300 is the height of waves
  //println(abs(sin(grow))*100);
  background(146, 110, 75);
  translate(mouseX, mouseY); // Center the program at mouse location
  
  
  
  for( int i=0; i<count; i++){  // For loop to make copies of 'arms' 
    //println(int(armColors[0]));
  rotX[i] += .02;  
  rotY[i] += .3;   
  rotZ[i] += .03;  
  //rotateY(radians(360/float(count)*i));  // Merry Go Round
    
  pushMatrix();
  
  rotateY(radians(rotY[i])); // Rotates each arm out on X axis
  rotateX(radians(rotX[i])); // Rotates each arm out on Y axis
  rotateZ(radians(rotZ[i])); // Rotates each arm out on Z axis
  stroke(255);
  line(0,0, wavy+200,0); // 1) Line draw from Origin
 // line(300,-50,300,50);
  pushMatrix();  // 5) push/pop used to isolate rotation/translate to one section
  translate(wavy+100,0); // 4) Move rect after rotation out in X axis
  rotateY(radians(90)); //3) Rotate rect by 90 degrees so it's normal to line 
  fill(armColors[i],100);
  //rect(0,0, sizes[i],sizes[i]); //  2) Then Draw Rect, at Origin (need to rotate around center)
  noStroke();
  
  sphere(100-wavy/8);
  popMatrix();
  popMatrix();
  }
  
}


//void mouseMoved(){
//  for (int t=0; t<count; t++){
//    armColors[t] = palette[int(random(5))];
//  }
//}













