PFont myFont;
import SimpleOpenNI.*;
SimpleOpenNI  kinect;

void setup() {
  kinect = new SimpleOpenNI(this);
  kinect.enableDepth();
  kinect.enableUser(SimpleOpenNI.SKEL_PROFILE_ALL);
  kinect.setMirror(true); // Sets mirroring on/off
  size(640, 480);
  stroke(255, 0, 0);
  strokeWeight(5);
  //textSize(20);
  myFont = loadFont("s36.vlw");
  textFont(myFont, 23);
  
}

void draw() {
  kinect.update();
  image(kinect.depthImage(), 0, 0);

  IntVector userList = new IntVector();
  kinect.getUsers(userList);

  if (userList.size() > 0) {
    int userId = userList.get(0);

    if ( kinect.isTrackingSkeleton(userId)) {
      PVector leftHand = new PVector();
      PVector rightHand = new PVector();
      PVector rightKnee = new PVector();

      kinect.getJointPositionSkeleton(userId,
                                      SimpleOpenNI.SKEL_LEFT_HAND,
                                      leftHand);

      kinect.getJointPositionSkeleton(userId,
                                      SimpleOpenNI.SKEL_RIGHT_HAND,
                                      rightHand);
                                      
      kinect.getJointPositionSkeleton(userId,
                                      SimpleOpenNI.SKEL_LEFT_KNEE,
                                      rightKnee);                           

      // calculate difference by subtracting one vector from another
      PVector handKnee = PVector.sub(leftHand, rightKnee);
     
      // calculate the distance and direction of the difference vector
      PVector differenceVector = PVector.sub(leftHand, rightHand); 
      float magnitude = differenceVector.mag(); 
      differenceVector.normalize(); 
      
      float magnitudeHandKnee = handKnee.mag(); 
      handKnee.normalize(); 

      // draw a line between the two hands
     kinect.drawLimb(userId, SimpleOpenNI.SKEL_LEFT_HAND, 
     SimpleOpenNI.SKEL_RIGHT_HAND);
      

      // Draw shape over hand(s)
      PVector convertedLeftHand = new PVector();
      kinect.convertRealWorldToProjective(leftHand, convertedLeftHand);
      PVector convertedRightHand = new PVector();
      kinect.convertRealWorldToProjective(rightHand, convertedRightHand);
      // and display it
      noStroke();
      fill(55, 0, 255);
      ellipse(convertedLeftHand.x, convertedLeftHand.y, 40, 40);
      
      fill(255, 104, 0);
      rect(convertedRightHand.x, convertedRightHand.y, 40, 40);
      
      // display
      pushMatrix();
     fill(0);
     noStroke();
    rect(0,0,width, 75); // BG for top distance
    rect(0,height-70,width, height); // BG for bottom reading
   //Returns Stroke to large and red so lines between Limbs are visible
   stroke(255, 0, 0);
  strokeWeight(5); 
        fill(abs(differenceVector.x) * 255, 
             abs(differenceVector.y) * 255,
             abs(differenceVector.z) * 255);

       
        text("Distance between hands: "+ magnitude, 10, 50);
       
       fill(0,205,0);
       text("LeftHand x: " + nf(leftHand.x,0,1) + ", y: " + nf(leftHand.y,0,1) + "z: " + nf(leftHand.z,0,1), 10, height-10);
     //text("m2: "+ magnitudeHandKnee, 10, height -75);
      popMatrix();
    }
  }
}


// user-tracking callbacks!
void onNewUser(int userId) {
  println("start pose detection");
  kinect.startPoseDetection("Psi", userId);
}

void onEndCalibration(int userId, boolean successful) {
  if (successful) {
    println("  User calibrated !!!");
    kinect.startTrackingSkeleton(userId);
  }
  else {
    println("  Failed to calibrate user !!!");
    kinect.startPoseDetection("Psi", userId);
  }
}

void onStartPose(String pose, int userId) {
  println("Started pose for user");
  kinect.stopPoseDetection(userId);
  kinect.requestCalibrationSkeleton(userId, true);
}

