import SimpleOpenNI.*;
SimpleOpenNI kinect; 


String[] list1 = {
  "HOT!", 
  "COOL...", 
  "Dead Cold!",
};

PFont f; // Global font variable

void setup() {
  size(640, 480);
  f = createFont( "Bebas Neue", 16, true);
  kinect = new SimpleOpenNI(this);
  kinect.enableDepth(); 
  kinect.enableUser(SimpleOpenNI.SKEL_PROFILE_NONE);
}

void draw() {
  //not kinect stuff//
  textFont(f, 170);
  textAlign (CENTER);
  background(0, 0, 0);
  fill(255);
  kinect.update();

  //image(kinect.depthImage(), 0, 0); // Hide/Show the Kinect Camera Image

  IntVector userList = new IntVector();
  kinect.getUsers(userList);

// HERE IS THE HEART OF THE PROGRAM
// The VALUE of the Center of Mass of the user is called: position.z
//If you need to use it in a sketch, refer to it as position.z, knowing that each unit is a millimeter (1000mm = 3.2')
  for (int i=0; i<userList.size(); i++) {
    int userId = userList.get(i); 
    PVector position = new PVector(); 
    kinect.getCoM(userId, position); 
    kinect.convertRealWorldToProjective(position, position);
    
    textSize(16);
    text("PositionZ is: "+position.z, width/2, height-20);
    if (position.z < 1100) {

      textFont(f, 100);
      text(list1[0], width/2, height/2);


      //draw text number one //
    }

    else if (position.z > 1100 && position.z < 2000) {
      textFont(f, 100);
      text(list1[1], width/2, height/2); 
      //draw text number two //
    }

    else if  (position.z > 2000) {
      textFont(f, 100);
      text(list1[2], width/2, height/2);
    }
    //println(position.z);
  }
}

