/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import toxi.geom.Line2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Ray2D
extends Vec2D {
    @XmlElement(required=true)
    protected Vec2D dir;

    public Ray2D() {
        this.dir = Vec2D.Y_AXIS.copy();
    }

    public Ray2D(float f, float f2, ReadonlyVec2D readonlyVec2D) {
        super(f, f2);
        this.dir = readonlyVec2D.getNormalized();
    }

    public Ray2D(ReadonlyVec2D readonlyVec2D, ReadonlyVec2D readonlyVec2D2) {
        this(readonlyVec2D.x(), readonlyVec2D.y(), readonlyVec2D2);
    }

    public Vec2D getDirection() {
        return this.dir.copy();
    }

    public float getDistanceToPoint(Vec2D vec2D) {
        Vec2D vec2D2 = vec2D.sub(this);
        return vec2D2.distanceTo(this.dir.scale(vec2D2.dot(this.dir)));
    }

    public Vec2D getPointAtDistance(float f) {
        return this.add(this.dir.scale(f));
    }

    public Ray2D setDirection(ReadonlyVec2D readonlyVec2D) {
        this.dir.set(readonlyVec2D).normalize();
        return this;
    }

    public Line2D toLine2DWithPointAtDistance(float f) {
        return new Line2D(this, this.getPointAtDistance(f));
    }

    public String toString() {
        return "origin: " + super.toString() + " dir: " + this.dir;
    }
}

