/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.geom.Line2D;
import toxi.geom.Polygon2D;
import toxi.geom.Ray2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Shape2D;
import toxi.geom.Vec2D;
import toxi.math.MathUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Rect
implements Shape2D {
    @XmlAttribute(required=true)
    public float x;
    @XmlAttribute(required=true)
    public float y;
    @XmlAttribute(required=true)
    public float width;
    @XmlAttribute(required=true)
    public float height;

    public static final Rect fromCenterExtent(ReadonlyVec2D readonlyVec2D, Vec2D vec2D) {
        return new Rect(readonlyVec2D.sub(vec2D), readonlyVec2D.add(vec2D));
    }

    public Rect() {
    }

    public Rect(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    public Rect(ReadonlyVec2D readonlyVec2D, ReadonlyVec2D readonlyVec2D2) {
        this.x = readonlyVec2D.x();
        this.y = readonlyVec2D.y();
        this.width = readonlyVec2D2.x() - this.x;
        this.height = readonlyVec2D2.y() - this.y;
    }

    public boolean containsPoint(ReadonlyVec2D readonlyVec2D) {
        float f = readonlyVec2D.x();
        float f2 = readonlyVec2D.y();
        if (f < this.x || f >= this.x + this.width) {
            return false;
        }
        return !(f2 < this.y) && !(f2 >= this.y + this.height);
    }

    public Rect copy() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    public final float getArea() {
        return this.width * this.height;
    }

    public final float getAspect() {
        return this.width / this.height;
    }

    public float getBottom() {
        return this.y + this.height;
    }

    public final Vec2D getBottomRight() {
        return new Vec2D(this.x + this.width, this.y + this.height);
    }

    public final Vec2D getCentroid() {
        return new Vec2D(this.x + this.width * 0.5f, this.y + this.height * 0.5f);
    }

    public final float getCircumference() {
        return 2.0f * this.width + 2.0f * this.height;
    }

    public final Vec2D getDimensions() {
        return new Vec2D(this.width, this.height);
    }

    public Line2D getEdge(int n) {
        Line2D line2D = null;
        switch (n) {
            case 0: {
                line2D = new Line2D(new Vec2D(this.x, this.y), new Vec2D(this.x + this.width, this.y));
                break;
            }
            case 1: {
                line2D = new Line2D(new Vec2D(this.x + this.width, this.y), new Vec2D(this.x + this.width, this.y + this.height));
                break;
            }
            case 2: {
                line2D = new Line2D(new Vec2D(this.x, this.y + this.height), new Vec2D(this.x + this.width, this.y + this.height));
                break;
            }
            case 3: {
                line2D = new Line2D(new Vec2D(this.x, this.y), new Vec2D(this.x, this.y + this.height));
                break;
            }
            default: {
                throw new IllegalArgumentException("edge ID needs to be 0...3");
            }
        }
        return line2D;
    }

    public float getLeft() {
        return this.x;
    }

    public float getRight() {
        return this.x + this.width;
    }

    public float getTop() {
        return this.y;
    }

    public final Vec2D getTopLeft() {
        return new Vec2D(this.x, this.y);
    }

    public ReadonlyVec2D intersectsRay(Ray2D ray2D, float f, float f2) {
        Vec2D vec2D = ray2D.getDirection().reciprocal();
        boolean bl = vec2D.x < 0.0f;
        boolean bl2 = vec2D.y < 0.0f;
        Vec2D vec2D2 = this.getTopLeft();
        Vec2D vec2D3 = this.getBottomRight();
        Vec2D vec2D4 = bl ? vec2D3 : vec2D2;
        float f3 = (vec2D4.x - ray2D.x) * vec2D.x;
        vec2D4 = bl ? vec2D2 : vec2D3;
        float f4 = (vec2D4.x - ray2D.x) * vec2D.x;
        vec2D4 = bl2 ? vec2D3 : vec2D2;
        float f5 = (vec2D4.y - ray2D.y) * vec2D.y;
        vec2D4 = bl2 ? vec2D2 : vec2D3;
        float f6 = (vec2D4.y - ray2D.y) * vec2D.y;
        if (f3 > f6 || f5 > f4) {
            return null;
        }
        if (f5 > f3) {
            f3 = f5;
        }
        if (f6 < f4) {
            f4 = f6;
        }
        if (f3 < f2 && f4 > f) {
            return ray2D.getPointAtDistance(f3);
        }
        return null;
    }

    public boolean intersectsRect(Rect rect) {
        return !(this.x > rect.x + rect.width || this.x + this.width < rect.x || this.y > rect.y + rect.height || this.y + this.height < rect.y);
    }

    public Rect scale(float f) {
        Vec2D vec2D = this.getCentroid();
        this.width *= f;
        this.height *= f;
        this.x = vec2D.x - this.width * 0.5f;
        this.y = vec2D.y - this.height * 0.5f;
        return this;
    }

    public final Rect set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
        return this;
    }

    public final Rect set(Rect rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
        return this;
    }

    public final Rect setDimension(Vec2D vec2D) {
        this.width = vec2D.x;
        this.height = vec2D.y;
        return this;
    }

    public final Rect setPosition(Vec2D vec2D) {
        this.x = vec2D.x;
        this.y = vec2D.y;
        return this;
    }

    public Polygon2D toPolygon2D() {
        Polygon2D polygon2D = new Polygon2D();
        polygon2D.add(new Vec2D(this.x, this.y));
        polygon2D.add(new Vec2D(this.x + this.width, this.y));
        polygon2D.add(new Vec2D(this.x + this.width, this.y + this.height));
        polygon2D.add(new Vec2D(this.x, this.y + this.height));
        return polygon2D;
    }

    public String toString() {
        return "rect: {x:" + this.x + ", y:" + this.y + ", width:" + this.width + ", height:" + this.height + "}";
    }

    public final Rect union(Rect rect) {
        float f = MathUtils.max(this.x + this.width, rect.x + rect.width);
        this.x = MathUtils.min(this.x, rect.x);
        this.width = f - this.x;
        f = MathUtils.max(this.y + this.height, rect.y + rect.height);
        this.y = MathUtils.min(this.y, rect.y);
        this.height = f - this.y;
        return this;
    }
}

