/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.Vertex;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VertexSelector {
    protected Mesh3D mesh;
    protected Set<Vertex> selection;

    public VertexSelector(Mesh3D mesh3D) {
        this.mesh = mesh3D;
        this.selection = new HashSet<Vertex>();
    }

    public VertexSelector addSelection(VertexSelector vertexSelector) {
        this.checkMeshIdentity(vertexSelector.getMesh());
        this.selection.addAll(vertexSelector.getSelection());
        return this;
    }

    protected void checkMeshIdentity(Mesh3D mesh3D) {
        if (mesh3D != this.mesh) {
            throw new IllegalArgumentException("The given selector is not using the same mesh instance");
        }
    }

    public VertexSelector clearSelection() {
        this.selection.clear();
        return this;
    }

    public Mesh3D getMesh() {
        return this.mesh;
    }

    public Collection<Vertex> getSelection() {
        return this.selection;
    }

    public VertexSelector invertSelection() {
        int n = MathUtils.max(0, this.mesh.getNumVertices() - this.selection.size());
        HashSet<Vertex> hashSet = new HashSet<Vertex>(n);
        for (Vertex vertex : this.mesh.getVertices()) {
            if (this.selection.contains(vertex)) continue;
            hashSet.add(vertex);
        }
        this.selection = hashSet;
        return this;
    }

    public VertexSelector selectSimilar(Collection<? extends Vec3D> collection) {
        for (Vec3D vec3D : collection) {
            this.selection.add(this.mesh.getClosestVertexToPoint(vec3D));
        }
        return this;
    }

    public abstract VertexSelector selectVertices();

    public void setMesh(Mesh3D mesh3D) {
        this.mesh = mesh3D;
        this.clearSelection();
    }

    public int size() {
        return this.selection.size();
    }

    public VertexSelector subtractSelection(VertexSelector vertexSelector) {
        this.checkMeshIdentity(vertexSelector.getMesh());
        this.selection.removeAll(vertexSelector.getSelection());
        return this;
    }
}

