/*
 * Decompiled with CFR 0.152.
 */
package toxi.math.noise;

import java.util.Random;
import toxi.math.SinCosLUT;

public class PerlinNoise {
    protected static final int PERLIN_YWRAPB = 4;
    protected static final int PERLIN_YWRAP = 16;
    protected static final int PERLIN_ZWRAPB = 8;
    protected static final int PERLIN_ZWRAP = 256;
    protected static final int PERLIN_SIZE = 4095;
    private static final float PERLIN_MIN_AMPLITUDE = 0.001f;
    protected int perlin_octaves = 4;
    protected float perlin_amp_falloff = 0.5f;
    protected int perlin_TWOPI;
    protected int perlin_PI;
    protected float[] perlin_cosTable;
    protected float[] perlin;
    protected Random perlinRandom;

    public PerlinNoise() {
        this.noiseSeed(System.nanoTime());
    }

    public float noise(float f) {
        return this.noise(f, 0.0f, 0.0f);
    }

    public float noise(float f, float f2) {
        return this.noise(f, f2, 0.0f);
    }

    public float noise(float f, float f2, float f3) {
        int n;
        if (this.perlin == null) {
            if (this.perlinRandom == null) {
                this.perlinRandom = new Random();
            }
            this.perlin = new float[4096];
            for (n = 0; n < 4096; ++n) {
                this.perlin[n] = this.perlinRandom.nextFloat();
            }
            this.perlin_cosTable = SinCosLUT.getDefaultInstance().getSinLUT();
            this.perlin_TWOPI = this.perlin_PI = SinCosLUT.getDefaultInstance().getPeriod();
            this.perlin_PI >>= 1;
        }
        if (f < 0.0f) {
            f = -f;
        }
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        n = (int)f;
        int n2 = (int)f2;
        int n3 = (int)f3;
        float f4 = f - (float)n;
        float f5 = f2 - (float)n2;
        float f6 = f3 - (float)n3;
        float f7 = 0.0f;
        float f8 = 0.5f;
        for (int i = 0; i < this.perlin_octaves; ++i) {
            int n4 = n + (n2 << 4) + (n3 << 8);
            float f9 = this.noise_fsc(f4);
            float f10 = this.noise_fsc(f5);
            float f11 = this.perlin[n4 & 0xFFF];
            f11 += f9 * (this.perlin[n4 + 1 & 0xFFF] - f11);
            float f12 = this.perlin[n4 + 16 & 0xFFF];
            f12 += f9 * (this.perlin[n4 + 16 + 1 & 0xFFF] - f12);
            f11 += f10 * (f12 - f11);
            f12 = this.perlin[(n4 += 256) & 0xFFF];
            f12 += f9 * (this.perlin[n4 + 1 & 0xFFF] - f12);
            float f13 = this.perlin[n4 + 16 & 0xFFF];
            f13 += f9 * (this.perlin[n4 + 16 + 1 & 0xFFF] - f13);
            f12 += f10 * (f13 - f12);
            f11 += this.noise_fsc(f6) * (f12 - f11);
            f7 += f11 * f8;
            if ((f8 *= this.perlin_amp_falloff) < 0.001f) break;
            n <<= 1;
            f4 *= 2.0f;
            n2 <<= 1;
            f5 *= 2.0f;
            n3 <<= 1;
            f6 *= 2.0f;
            if (f4 >= 1.0f) {
                ++n;
                f4 -= 1.0f;
            }
            if (f5 >= 1.0f) {
                ++n2;
                f5 -= 1.0f;
            }
            if (!(f6 >= 1.0f)) continue;
            ++n3;
            f6 -= 1.0f;
        }
        return f7;
    }

    private float noise_fsc(float f) {
        return 0.5f * (1.0f - this.perlin_cosTable[(int)((f + 0.5f) * (float)this.perlin_PI) % this.perlin_TWOPI]);
    }

    public void noiseDetail(int n) {
        if (n > 0) {
            this.perlin_octaves = n;
        }
    }

    public void noiseDetail(int n, float f) {
        if (n > 0) {
            this.perlin_octaves = n;
        }
        if (f > 0.0f) {
            this.perlin_amp_falloff = f;
        }
    }

    public void noiseSeed(long l) {
        if (this.perlinRandom == null) {
            this.perlinRandom = new Random();
        }
        this.perlinRandom.setSeed(l);
        this.perlin = null;
    }
}

