/*
 * Decompiled with CFR 0.152.
 */
package toxi.util;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import toxi.util.FileSequenceDescriptor;

public class FileUtils {
    public static void createDirectories(File file) {
        try {
            File file2;
            String string = file.getParent();
            if (string != null && !(file2 = new File(string)).exists()) {
                file2.mkdirs();
            }
        }
        catch (SecurityException securityException) {
            System.err.println("No permissions to create " + file.getAbsolutePath());
        }
    }

    public static InputStream createInputStream(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        InputStream inputStream = new FileInputStream(file);
        if (file.getName().toLowerCase().endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static OutputStream createOutputStream(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        FileUtils.createDirectories(file);
        OutputStream outputStream = new FileOutputStream(file);
        if (file.getName().toLowerCase().endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        return outputStream;
    }

    public static BufferedReader createReader(File file) throws IOException {
        return FileUtils.createReader(FileUtils.createInputStream(file));
    }

    public static BufferedReader createReader(InputStream inputStream) {
        return FileUtils.createReader(inputStream, "UTF-8");
    }

    public static BufferedReader createReader(InputStream inputStream, String string) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new BufferedReader(inputStreamReader);
    }

    public static PrintWriter createWriter(File file) throws IOException {
        return FileUtils.createWriter(FileUtils.createOutputStream(file));
    }

    public static PrintWriter createWriter(OutputStream outputStream) {
        return FileUtils.createWriter(outputStream, "UTF-8");
    }

    public static PrintWriter createWriter(OutputStream outputStream, String string) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new PrintWriter(outputStreamWriter);
    }

    public static FileSequenceDescriptor getFileSequenceDescriptorFor(String string) {
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(45) + 1;
        if (n2 == 0) {
            n2 = n - 1;
            while (string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
                --n2;
            }
            ++n2;
        }
        int n3 = n - n2;
        if (n != -1 && n3 > 0) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n);
            String string4 = string2 + "%0" + n3 + "d" + string3;
            int n4 = Integer.parseInt(string.substring(n2, n));
            return new FileSequenceDescriptor(string4, string3, n - n2, n4);
        }
        return null;
    }

    public static byte[] loadBytes(InputStream inputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = bufferedInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String loadText(BufferedReader bufferedReader) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String loadText(InputStream inputStream) throws IOException {
        return FileUtils.loadText(inputStream, "UTF-8");
    }

    public static String loadText(InputStream inputStream, String string) throws IOException {
        byte[] byArray = FileUtils.loadBytes(inputStream);
        return new String(byArray, string);
    }

    public static void saveText(OutputStream outputStream, String string) {
        FileUtils.saveText(FileUtils.createWriter(outputStream), string);
    }

    public static void saveText(PrintWriter printWriter, String string) {
        printWriter.println(string);
        printWriter.flush();
        printWriter.close();
    }

    public static String showFileDialog(Frame frame, String string, String string2, final String[] stringArray, int n) {
        String string3 = null;
        FileDialog fileDialog = new FileDialog(frame, string, n);
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        if (stringArray != null) {
            fileDialog.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    boolean bl = false;
                    for (String string2 : stringArray) {
                        if (string.indexOf(string2) == -1) continue;
                        bl = true;
                        break;
                    }
                    return bl;
                }
            });
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            string3 = fileDialog.getFile();
            string3 = fileDialog.getDirectory() + string3;
        }
        return string3;
    }
}

