/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import traer.physics.Force;
import traer.physics.Particle;

public class Attraction
implements Force {
    Particle a;
    Particle b;
    float k;
    boolean on;
    float distanceMin;
    float distanceMinSquared;

    public Attraction(Particle a, Particle b, float k, float distanceMin) {
        this.a = a;
        this.b = b;
        this.k = k;
        this.on = true;
        this.distanceMin = distanceMin;
        this.distanceMinSquared = distanceMin * distanceMin;
    }

    protected void setA(Particle p) {
        this.a = p;
    }

    protected void setB(Particle p) {
        this.b = p;
    }

    public final float getMinimumDistance() {
        return this.distanceMin;
    }

    public final void setMinimumDistance(float d) {
        this.distanceMin = d;
        this.distanceMinSquared = d * d;
    }

    public final void turnOff() {
        this.on = false;
    }

    public final void turnOn() {
        this.on = true;
    }

    public final void setStrength(float k) {
        this.k = k;
    }

    public final Particle getOneEnd() {
        return this.a;
    }

    public final Particle getTheOtherEnd() {
        return this.b;
    }

    public void apply() {
        if (this.on && (this.a.isFree() || this.b.isFree())) {
            float a2bZ;
            float a2bY;
            float a2bX = this.a.position().x() - this.b.position().x();
            float a2bDistanceSquared = a2bX * a2bX + (a2bY = this.a.position().y() - this.b.position().y()) * a2bY + (a2bZ = this.a.position().z() - this.b.position().z()) * a2bZ;
            if (a2bDistanceSquared < this.distanceMinSquared) {
                a2bDistanceSquared = this.distanceMinSquared;
            }
            float force = this.k * this.a.mass * this.b.mass / a2bDistanceSquared;
            float length = (float)Math.sqrt(a2bDistanceSquared);
            a2bX /= length;
            a2bY /= length;
            a2bZ /= length;
            a2bX *= force;
            a2bY *= force;
            a2bZ *= force;
            if (this.a.isFree()) {
                this.a.force().add(-a2bX, -a2bY, -a2bZ);
            }
            if (this.b.isFree()) {
                this.b.force().add(a2bX, a2bY, a2bZ);
            }
        }
    }

    public final float getStrength() {
        return this.k;
    }

    public final boolean isOn() {
        return this.on;
    }

    public final boolean isOff() {
        return !this.on;
    }
}

