/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import traer.physics.Integrator;
import traer.physics.Particle;
import traer.physics.ParticleSystem;

public class EulerIntegrator
implements Integrator {
    ParticleSystem s;

    public EulerIntegrator(ParticleSystem s) {
        this.s = s;
    }

    public void step(float t) {
        this.s.clearForces();
        this.s.applyForces();
        int i = 0;
        while (i < this.s.numberOfParticles()) {
            Particle p = this.s.getParticle(i);
            if (p.isFree()) {
                p.velocity().add(p.force().x() / (p.mass() * t), p.force().y() / (p.mass() * t), p.force().z() / (p.mass() * t));
                p.position().add(p.velocity().x() / t, p.velocity().y() / t, p.velocity().z() / t);
            }
            ++i;
        }
    }
}

