/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import traer.physics.Integrator;
import traer.physics.Particle;
import traer.physics.ParticleSystem;

public class ModifiedEulerIntegrator
implements Integrator {
    ParticleSystem s;

    public ModifiedEulerIntegrator(ParticleSystem s) {
        this.s = s;
    }

    public void step(float t) {
        this.s.clearForces();
        this.s.applyForces();
        float halftt = 0.5f * t * t;
        int i = 0;
        while (i < this.s.numberOfParticles()) {
            Particle p = this.s.getParticle(i);
            if (p.isFree()) {
                float ax = p.force().x() / p.mass();
                float ay = p.force().y() / p.mass();
                float az = p.force().z() / p.mass();
                p.position().add(p.velocity().x() / t, p.velocity().y() / t, p.velocity().z() / t);
                p.position().add(ax * halftt, ay * halftt, az * halftt);
                p.velocity().add(ax / t, ay / t, az / t);
            }
            ++i;
        }
    }
}

