/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import traer.physics.Vector3D;

public class Particle {
    protected Vector3D position = new Vector3D();
    protected Vector3D velocity = new Vector3D();
    protected Vector3D force = new Vector3D();
    protected float mass;
    protected float age;
    protected boolean dead;
    boolean fixed;

    public Particle(float m) {
        this.mass = m;
        this.fixed = false;
        this.age = 0.0f;
        this.dead = false;
    }

    public final float distanceTo(Particle p) {
        return this.position().distanceTo(p.position());
    }

    public final void makeFixed() {
        this.fixed = true;
        this.velocity.clear();
    }

    public final boolean isFixed() {
        return this.fixed;
    }

    public final boolean isFree() {
        return !this.fixed;
    }

    public final void makeFree() {
        this.fixed = false;
    }

    public final Vector3D position() {
        return this.position;
    }

    public final Vector3D velocity() {
        return this.velocity;
    }

    public final float mass() {
        return this.mass;
    }

    public final void setMass(float m) {
        this.mass = m;
    }

    public final Vector3D force() {
        return this.force;
    }

    public final float age() {
        return this.age;
    }

    protected void reset() {
        this.age = 0.0f;
        this.dead = false;
        this.position.clear();
        this.velocity.clear();
        this.force.clear();
        this.mass = 1.0f;
    }
}

