/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import java.util.ArrayList;
import traer.physics.Integrator;
import traer.physics.Particle;
import traer.physics.ParticleSystem;
import traer.physics.Vector3D;

public class RungeKuttaIntegrator
implements Integrator {
    ArrayList originalPositions;
    ArrayList originalVelocities;
    ArrayList k1Forces;
    ArrayList k1Velocities;
    ArrayList k2Forces;
    ArrayList k2Velocities;
    ArrayList k3Forces;
    ArrayList k3Velocities;
    ArrayList k4Forces;
    ArrayList k4Velocities;
    ParticleSystem s;

    public RungeKuttaIntegrator(ParticleSystem s) {
        this.s = s;
        this.originalPositions = new ArrayList();
        this.originalVelocities = new ArrayList();
        this.k1Forces = new ArrayList();
        this.k1Velocities = new ArrayList();
        this.k2Forces = new ArrayList();
        this.k2Velocities = new ArrayList();
        this.k3Forces = new ArrayList();
        this.k3Velocities = new ArrayList();
        this.k4Forces = new ArrayList();
        this.k4Velocities = new ArrayList();
    }

    final void allocateParticles() {
        while (this.s.particles.size() > this.originalPositions.size()) {
            this.originalPositions.add(new Vector3D());
            this.originalVelocities.add(new Vector3D());
            this.k1Forces.add(new Vector3D());
            this.k1Velocities.add(new Vector3D());
            this.k2Forces.add(new Vector3D());
            this.k2Velocities.add(new Vector3D());
            this.k3Forces.add(new Vector3D());
            this.k3Velocities.add(new Vector3D());
            this.k4Forces.add(new Vector3D());
            this.k4Velocities.add(new Vector3D());
        }
    }

    public final void step(float deltaT) {
        Vector3D originalVelocity;
        Vector3D k1Velocity;
        Vector3D originalPosition;
        Particle p;
        this.allocateParticles();
        int i = 0;
        while (i < this.s.particles.size()) {
            p = (Particle)this.s.particles.get(i);
            if (p.isFree()) {
                ((Vector3D)this.originalPositions.get(i)).set(p.position);
                ((Vector3D)this.originalVelocities.get(i)).set(p.velocity);
            }
            p.force.clear();
            ++i;
        }
        this.s.applyForces();
        i = 0;
        while (i < this.s.particles.size()) {
            p = (Particle)this.s.particles.get(i);
            if (p.isFree()) {
                ((Vector3D)this.k1Forces.get(i)).set(p.force);
                ((Vector3D)this.k1Velocities.get(i)).set(p.velocity);
            }
            p.force.clear();
            ++i;
        }
        i = 0;
        while (i < this.s.particles.size()) {
            p = (Particle)this.s.particles.get(i);
            if (p.isFree()) {
                originalPosition = (Vector3D)this.originalPositions.get(i);
                k1Velocity = (Vector3D)this.k1Velocities.get(i);
                p.position.x = originalPosition.x + k1Velocity.x * 0.5f * deltaT;
                p.position.y = originalPosition.y + k1Velocity.y * 0.5f * deltaT;
                p.position.z = originalPosition.z + k1Velocity.z * 0.5f * deltaT;
                originalVelocity = (Vector3D)this.originalVelocities.get(i);
                Vector3D k1Force = (Vector3D)this.k1Forces.get(i);
                p.velocity.x = originalVelocity.x + k1Force.x * 0.5f * deltaT / p.mass;
                p.velocity.y = originalVelocity.y + k1Force.y * 0.5f * deltaT / p.mass;
                p.velocity.z = originalVelocity.z + k1Force.z * 0.5f * deltaT / p.mass;
            }
            ++i;
        }
        this.s.applyForces();
        i = 0;
        while (i < this.s.particles.size()) {
            p = (Particle)this.s.particles.get(i);
            if (p.isFree()) {
                ((Vector3D)this.k2Forces.get(i)).set(p.force);
                ((Vector3D)this.k2Velocities.get(i)).set(p.velocity);
            }
            p.force.clear();
            ++i;
        }
        i = 0;
        while (i < this.s.particles.size()) {
            p = (Particle)this.s.particles.get(i);
            if (p.isFree()) {
                originalPosition = (Vector3D)this.originalPositions.get(i);
                Vector3D k2Velocity = (Vector3D)this.k2Velocities.get(i);
                p.position.x = originalPosition.x + k2Velocity.x * 0.5f * deltaT;
                p.position.y = originalPosition.y + k2Velocity.y * 0.5f * deltaT;
                p.position.z = originalPosition.z + k2Velocity.z * 0.5f * deltaT;
                originalVelocity = (Vector3D)this.originalVelocities.get(i);
                Vector3D k2Force = (Vector3D)this.k2Forces.get(i);
                p.velocity.x = originalVelocity.x + k2Force.x * 0.5f * deltaT / p.mass;
                p.velocity.y = originalVelocity.y + k2Force.y * 0.5f * deltaT / p.mass;
                p.velocity.z = originalVelocity.z + k2Force.z * 0.5f * deltaT / p.mass;
            }
            ++i;
        }
        this.s.applyForces();
        i = 0;
        while (i < this.s.particles.size()) {
            p = (Particle)this.s.particles.get(i);
            if (p.isFree()) {
                ((Vector3D)this.k3Forces.get(i)).set(p.force);
                ((Vector3D)this.k3Velocities.get(i)).set(p.velocity);
            }
            p.force.clear();
            ++i;
        }
        i = 0;
        while (i < this.s.particles.size()) {
            p = (Particle)this.s.particles.get(i);
            if (p.isFree()) {
                originalPosition = (Vector3D)this.originalPositions.get(i);
                Vector3D k3Velocity = (Vector3D)this.k3Velocities.get(i);
                p.position.x = originalPosition.x + k3Velocity.x * deltaT;
                p.position.y = originalPosition.y + k3Velocity.y * deltaT;
                p.position.z = originalPosition.z + k3Velocity.z * deltaT;
                originalVelocity = (Vector3D)this.originalVelocities.get(i);
                Vector3D k3Force = (Vector3D)this.k3Forces.get(i);
                p.velocity.x = originalVelocity.x + k3Force.x * deltaT / p.mass;
                p.velocity.y = originalVelocity.y + k3Force.y * deltaT / p.mass;
                p.velocity.z = originalVelocity.z + k3Force.z * deltaT / p.mass;
            }
            ++i;
        }
        this.s.applyForces();
        i = 0;
        while (i < this.s.particles.size()) {
            p = (Particle)this.s.particles.get(i);
            if (p.isFree()) {
                ((Vector3D)this.k4Forces.get(i)).set(p.force);
                ((Vector3D)this.k4Velocities.get(i)).set(p.velocity);
            }
            ++i;
        }
        i = 0;
        while (i < this.s.particles.size()) {
            p = (Particle)this.s.particles.get(i);
            p.age += deltaT;
            if (p.isFree()) {
                originalPosition = (Vector3D)this.originalPositions.get(i);
                k1Velocity = (Vector3D)this.k1Velocities.get(i);
                Vector3D k2Velocity = (Vector3D)this.k2Velocities.get(i);
                Vector3D k3Velocity = (Vector3D)this.k3Velocities.get(i);
                Vector3D k4Velocity = (Vector3D)this.k4Velocities.get(i);
                p.position.x = originalPosition.x + deltaT / 6.0f * (k1Velocity.x + 2.0f * k2Velocity.x + 2.0f * k3Velocity.x + k4Velocity.x);
                p.position.y = originalPosition.y + deltaT / 6.0f * (k1Velocity.y + 2.0f * k2Velocity.y + 2.0f * k3Velocity.y + k4Velocity.y);
                p.position.z = originalPosition.z + deltaT / 6.0f * (k1Velocity.z + 2.0f * k2Velocity.z + 2.0f * k3Velocity.z + k4Velocity.z);
                Vector3D originalVelocity2 = (Vector3D)this.originalVelocities.get(i);
                Vector3D k1Force = (Vector3D)this.k1Forces.get(i);
                Vector3D k2Force = (Vector3D)this.k2Forces.get(i);
                Vector3D k3Force = (Vector3D)this.k3Forces.get(i);
                Vector3D k4Force = (Vector3D)this.k4Forces.get(i);
                p.velocity.x = originalVelocity2.x + deltaT / (6.0f * p.mass) * (k1Force.x + 2.0f * k2Force.x + 2.0f * k3Force.x + k4Force.x);
                p.velocity.y = originalVelocity2.y + deltaT / (6.0f * p.mass) * (k1Force.y + 2.0f * k2Force.y + 2.0f * k3Force.y + k4Force.y);
                p.velocity.z = originalVelocity2.z + deltaT / (6.0f * p.mass) * (k1Force.z + 2.0f * k2Force.z + 2.0f * k3Force.z + k4Force.z);
            }
            ++i;
        }
    }
}

