/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

public class Vector3D {
    float x;
    float y;
    float z;

    public Vector3D(float X, float Y, float Z) {
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public Vector3D() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector3D(Vector3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public final float z() {
        return this.z;
    }

    public final float y() {
        return this.y;
    }

    public final float x() {
        return this.x;
    }

    public final void setX(float X) {
        this.x = X;
    }

    public final void setY(float Y) {
        this.y = Y;
    }

    public final void setZ(float Z) {
        this.z = Z;
    }

    public final void set(float X, float Y, float Z) {
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public final void set(Vector3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public final void add(Vector3D p) {
        this.x += p.x;
        this.y += p.y;
        this.z += p.z;
    }

    public final void subtract(Vector3D p) {
        this.x -= p.x;
        this.y -= p.y;
        this.z -= p.z;
    }

    public final void add(float a, float b, float c) {
        this.x += a;
        this.y += b;
        this.z += c;
    }

    public final void subtract(float a, float b, float c) {
        this.x -= a;
        this.y -= b;
        this.z -= c;
    }

    public final Vector3D multiplyBy(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public final float distanceTo(Vector3D p) {
        return (float)Math.sqrt(this.distanceSquaredTo(p));
    }

    public final float distanceSquaredTo(Vector3D p) {
        float dx = this.x - p.x;
        float dy = this.y - p.y;
        float dz = this.z - p.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final float distanceTo(float x, float y, float z) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final float dot(Vector3D p) {
        return this.x * p.x + this.y * p.y + this.z * p.z;
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final void clear() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public final String toString() {
        return new String("(" + this.x + ", " + this.y + ", " + this.z + ")");
    }

    public final Vector3D cross(Vector3D p) {
        return new Vector3D(this.y * p.z - this.z * p.y, this.x * p.z - this.z * p.x, this.x * p.y - this.y * p.x);
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }
}

