/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class ChainShape
extends Shape {
    public Vec2[] m_vertices = null;
    public int m_count;
    public final Vec2 m_prevVertex = new Vec2();
    public final Vec2 m_nextVertex = new Vec2();
    public boolean m_hasPrevVertex = false;
    public boolean m_hasNextVertex = false;
    private final EdgeShape pool0 = new EdgeShape();
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();

    public ChainShape() {
        super(ShapeType.CHAIN);
        this.m_radius = 0.01f;
        this.m_count = 0;
    }

    @Override
    public int getChildCount() {
        return this.m_count - 1;
    }

    public void getChildEdge(EdgeShape edge, int index) {
        assert (index >= 0 && index < this.m_count - 1);
        edge.m_radius = this.m_radius;
        edge.m_vertex1.set(this.m_vertices[index + 0]);
        edge.m_vertex2.set(this.m_vertices[index + 1]);
        if (index > 0) {
            edge.m_vertex0.set(this.m_vertices[index - 1]);
            edge.m_hasVertex0 = true;
        } else {
            edge.m_vertex0.set(this.m_prevVertex);
            edge.m_hasVertex0 = this.m_hasPrevVertex;
        }
        if (index < this.m_count - 2) {
            edge.m_vertex3.set(this.m_vertices[index + 2]);
            edge.m_hasVertex3 = true;
        } else {
            edge.m_vertex3.set(this.m_nextVertex);
            edge.m_hasVertex3 = this.m_hasNextVertex;
        }
    }

    @Override
    public boolean testPoint(Transform xf, Vec2 p) {
        return false;
    }

    @Override
    public boolean raycast(RayCastOutput output, RayCastInput input, Transform xf, int childIndex) {
        assert (childIndex < this.m_count);
        EdgeShape edgeShape = this.pool0;
        int i1 = childIndex;
        int i2 = childIndex + 1;
        if (i2 == this.m_count) {
            i2 = 0;
        }
        edgeShape.m_vertex1.set(this.m_vertices[i1]);
        edgeShape.m_vertex2.set(this.m_vertices[i2]);
        return edgeShape.raycast(output, input, xf, 0);
    }

    @Override
    public void computeAABB(AABB aabb, Transform xf, int childIndex) {
        assert (childIndex < this.m_count);
        int i1 = childIndex;
        int i2 = childIndex + 1;
        if (i2 == this.m_count) {
            i2 = 0;
        }
        Vec2 v1 = this.pool1;
        Vec2 v2 = this.pool2;
        Transform.mulToOutUnsafe(xf, this.m_vertices[i1], v1);
        Transform.mulToOutUnsafe(xf, this.m_vertices[i2], v2);
        Vec2.minToOut(v1, v2, aabb.lowerBound);
        Vec2.maxToOut(v1, v2, aabb.upperBound);
    }

    @Override
    public void computeMass(MassData massData, float density) {
        massData.mass = 0.0f;
        massData.center.setZero();
        massData.I = 0.0f;
    }

    @Override
    public Shape clone() {
        ChainShape clone = new ChainShape();
        clone.createChain(this.m_vertices, this.m_count);
        clone.m_prevVertex.set(this.m_prevVertex);
        clone.m_nextVertex.set(this.m_nextVertex);
        clone.m_hasPrevVertex = this.m_hasPrevVertex;
        clone.m_hasNextVertex = this.m_hasNextVertex;
        return clone;
    }

    public void createLoop(Vec2[] vertices, int count) {
        assert (this.m_vertices == null && this.m_count == 0);
        assert (count >= 3);
        this.m_count = count + 1;
        this.m_vertices = new Vec2[this.m_count];
        int i = 0;
        while (i < count) {
            this.m_vertices[i] = new Vec2(vertices[i]);
            ++i;
        }
        this.m_vertices[count] = this.m_vertices[0];
        this.m_prevVertex.set(this.m_vertices[this.m_count - 2]);
        this.m_nextVertex.set(this.m_vertices[1]);
        this.m_hasPrevVertex = true;
        this.m_hasNextVertex = true;
    }

    public void createChain(Vec2[] vertices, int count) {
        assert (this.m_vertices == null && this.m_count == 0);
        assert (count >= 2);
        this.m_count = count;
        this.m_vertices = new Vec2[this.m_count];
        int i = 0;
        while (i < this.m_count) {
            this.m_vertices[i] = new Vec2(vertices[i]);
            ++i;
        }
        this.m_hasPrevVertex = false;
        this.m_hasNextVertex = false;
    }

    public void setPrevVertex(Vec2 prevVertex) {
        this.m_prevVertex.set(prevVertex);
        this.m_hasPrevVertex = true;
    }

    public void setNextVertex(Vec2 nextVertex) {
        this.m_nextVertex.set(nextVertex);
        this.m_hasNextVertex = true;
    }
}

