/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class EdgeShape
extends Shape {
    public final Vec2 m_vertex1 = new Vec2();
    public final Vec2 m_vertex2 = new Vec2();
    public final Vec2 m_vertex0 = new Vec2();
    public final Vec2 m_vertex3 = new Vec2();
    public boolean m_hasVertex0 = false;
    public boolean m_hasVertex3 = false;
    private final Vec2 pool0 = new Vec2();
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();
    private final Vec2 pool5 = new Vec2();

    public EdgeShape() {
        super(ShapeType.EDGE);
        this.m_radius = 0.01f;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    public void set(Vec2 v1, Vec2 v2) {
        this.m_vertex1.set(v1);
        this.m_vertex2.set(v2);
        this.m_hasVertex3 = false;
        this.m_hasVertex0 = false;
    }

    @Override
    public boolean testPoint(Transform xf, Vec2 p) {
        return false;
    }

    @Override
    public boolean raycast(RayCastOutput output, RayCastInput input, Transform xf, int childIndex) {
        Vec2 p1 = this.pool0.set(input.p1).subLocal(xf.p);
        Rot.mulTrans(xf.q, p1, p1);
        Vec2 p2 = this.pool1.set(input.p2).subLocal(xf.p);
        Rot.mulTrans(xf.q, p1, p1);
        Vec2 d = p2.subLocal(p1);
        Vec2 v1 = this.m_vertex1;
        Vec2 v2 = this.m_vertex2;
        Vec2 normal = this.pool2.set(v2).subLocal(v1);
        normal.set(normal.y, -normal.x);
        normal.normalize();
        this.pool3.set(v1).subLocal(p1);
        float numerator = Vec2.dot(normal, this.pool3);
        float denominator = Vec2.dot(normal, d);
        if (denominator == 0.0f) {
            return false;
        }
        float t = numerator / denominator;
        if (t < 0.0f || 1.0f < t) {
            return false;
        }
        Vec2 q = this.pool3;
        Vec2 r = this.pool4;
        q.set(d).mulLocal(t).addLocal(p1);
        r.set(v2).subLocal(v1);
        float rr = Vec2.dot(r, r);
        if (rr == 0.0f) {
            return false;
        }
        this.pool5.set(q).subLocal(v1);
        float s = Vec2.dot(this.pool5, r) / rr;
        if (s < 0.0f || 1.0f < s) {
            return false;
        }
        output.fraction = t;
        if (numerator > 0.0f) {
            output.normal.set(normal).negateLocal();
        } else {
            output.normal.set(normal);
        }
        return true;
    }

    @Override
    public void computeAABB(AABB aabb, Transform xf, int childIndex) {
        Vec2 v1 = this.pool1;
        Vec2 v2 = this.pool2;
        Transform.mulToOutUnsafe(xf, this.m_vertex1, v1);
        Transform.mulToOutUnsafe(xf, this.m_vertex2, v2);
        Vec2.minToOut(v1, v2, aabb.lowerBound);
        Vec2.maxToOut(v1, v2, aabb.upperBound);
        aabb.lowerBound.x -= this.m_radius;
        aabb.lowerBound.y -= this.m_radius;
        aabb.upperBound.x += this.m_radius;
        aabb.upperBound.y += this.m_radius;
    }

    @Override
    public void computeMass(MassData massData, float density) {
        massData.mass = 0.0f;
        massData.center.set(this.m_vertex1).addLocal(this.m_vertex2).mulLocal(0.5f);
        massData.I = 0.0f;
    }

    @Override
    public Shape clone() {
        EdgeShape edge = new EdgeShape();
        edge.m_radius = this.m_radius;
        edge.m_hasVertex0 = this.m_hasVertex0;
        edge.m_hasVertex3 = this.m_hasVertex3;
        edge.m_vertex0.set(this.m_vertex0);
        edge.m_vertex1.set(this.m_vertex1);
        edge.m_vertex2.set(this.m_vertex2);
        edge.m_vertex3.set(this.m_vertex3);
        return edge;
    }
}

