/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;

public class ConstantVolumeJoint
extends Joint {
    public final Body[] bodies;
    float[] targetLengths;
    public float targetVolume;
    Vec2[] normals;
    TimeStep m_step;
    private float m_impulse = 0.0f;
    private World world;
    DistanceJoint[] distanceJoints;
    public final float frequencyHz;
    public final float dampingRatio;

    public Body[] getBodies() {
        return this.bodies;
    }

    public DistanceJoint[] getJoints() {
        return this.distanceJoints;
    }

    public void inflate(float factor) {
        this.targetVolume *= factor;
    }

    public ConstantVolumeJoint(World argWorld, ConstantVolumeJointDef def) {
        super(argWorld.getPool(), def);
        this.world = argWorld;
        if (def.bodies.size() <= 2) {
            throw new IllegalArgumentException("You cannot create a constant volume joint with less than three bodies.");
        }
        this.bodies = def.bodies.toArray(new Body[0]);
        this.targetLengths = new float[this.bodies.length];
        int i = 0;
        while (i < this.targetLengths.length) {
            float dist;
            int next = i == this.targetLengths.length - 1 ? 0 : i + 1;
            this.targetLengths[i] = dist = this.bodies[i].getWorldCenter().sub(this.bodies[next].getWorldCenter()).length();
            ++i;
        }
        this.targetVolume = this.getArea();
        if (def.joints != null && def.joints.size() != def.bodies.size()) {
            throw new IllegalArgumentException("Incorrect joint definition.  Joints have to correspond to the bodies");
        }
        if (def.joints == null) {
            DistanceJointDef djd = new DistanceJointDef();
            this.distanceJoints = new DistanceJoint[this.bodies.length];
            int i2 = 0;
            while (i2 < this.targetLengths.length) {
                int next = i2 == this.targetLengths.length - 1 ? 0 : i2 + 1;
                djd.frequencyHz = def.frequencyHz;
                djd.dampingRatio = def.dampingRatio;
                djd.initialize(this.bodies[i2], this.bodies[next], this.bodies[i2].getWorldCenter(), this.bodies[next].getWorldCenter());
                this.distanceJoints[i2] = (DistanceJoint)this.world.createJoint(djd);
                ++i2;
            }
        } else {
            this.distanceJoints = def.joints.toArray(new DistanceJoint[0]);
        }
        this.frequencyHz = def.frequencyHz;
        this.dampingRatio = def.dampingRatio;
        this.normals = new Vec2[this.bodies.length];
        i = 0;
        while (i < this.normals.length) {
            this.normals[i] = new Vec2();
            ++i;
        }
        this.m_bodyA = this.bodies[0];
        this.m_bodyB = this.bodies[1];
        this.m_collideConnected = false;
    }

    @Override
    public void destructor() {
        int i = 0;
        while (i < this.distanceJoints.length) {
            this.world.destroyJoint(this.distanceJoints[i]);
            ++i;
        }
    }

    private float getArea() {
        float area = 0.0f;
        area += this.bodies[this.bodies.length - 1].getWorldCenter().x * this.bodies[0].getWorldCenter().y - this.bodies[0].getWorldCenter().x * this.bodies[this.bodies.length - 1].getWorldCenter().y;
        int i = 0;
        while (i < this.bodies.length - 1) {
            area += this.bodies[i].getWorldCenter().x * this.bodies[i + 1].getWorldCenter().y - this.bodies[i + 1].getWorldCenter().x * this.bodies[i].getWorldCenter().y;
            ++i;
        }
        return area *= 0.5f;
    }

    public boolean constrainEdges(TimeStep step) {
        float perimeter = 0.0f;
        int i = 0;
        while (i < this.bodies.length) {
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            float dx = this.bodies[next].getWorldCenter().x - this.bodies[i].getWorldCenter().x;
            float dy = this.bodies[next].getWorldCenter().y - this.bodies[i].getWorldCenter().y;
            float dist = MathUtils.sqrt(dx * dx + dy * dy);
            if (dist < 1.1920929E-7f) {
                dist = 1.0f;
            }
            this.normals[i].x = dy / dist;
            this.normals[i].y = -dx / dist;
            perimeter += dist;
            ++i;
        }
        Vec2 delta = this.pool.popVec2();
        float deltaArea = this.targetVolume - this.getArea();
        float toExtrude = 0.5f * deltaArea / perimeter;
        boolean done = true;
        int i2 = 0;
        while (i2 < this.bodies.length) {
            int next = i2 == this.bodies.length - 1 ? 0 : i2 + 1;
            delta.set(toExtrude * (this.normals[i2].x + this.normals[next].x), toExtrude * (this.normals[i2].y + this.normals[next].y));
            float norm = delta.length();
            if (norm > 0.2f) {
                delta.mulLocal(0.2f / norm);
            }
            if (norm > 0.005f) {
                done = false;
            }
            this.bodies[next].m_sweep.c.x += delta.x;
            this.bodies[next].m_sweep.c.y += delta.y;
            this.bodies[next].synchronizeTransform();
            ++i2;
        }
        this.pool.pushVec2(1);
        return done;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        Vec2[] d = this.pool.getVec2Array(this.bodies.length);
        int i = 0;
        while (i < this.bodies.length) {
            int prev = i == 0 ? this.bodies.length - 1 : i - 1;
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            d[i].set(this.bodies[next].getWorldCenter());
            d[i].subLocal(this.bodies[prev].getWorldCenter());
            ++i;
        }
        if (data.step.warmStarting) {
            this.m_impulse *= data.step.dtRatio;
            i = 0;
            while (i < this.bodies.length) {
                this.bodies[i].m_linearVelocity.x += this.bodies[i].m_invMass * d[i].y * 0.5f * this.m_impulse;
                this.bodies[i].m_linearVelocity.y += this.bodies[i].m_invMass * -d[i].x * 0.5f * this.m_impulse;
                ++i;
            }
        } else {
            this.m_impulse = 0.0f;
        }
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        return this.constrainEdges(data.step);
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        float crossMassSum = 0.0f;
        float dotMassSum = 0.0f;
        Vec2[] d = this.pool.getVec2Array(this.bodies.length);
        int i = 0;
        while (i < this.bodies.length) {
            int prev = i == 0 ? this.bodies.length - 1 : i - 1;
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            d[i].set(this.bodies[next].getWorldCenter());
            d[i].subLocal(this.bodies[prev].getWorldCenter());
            dotMassSum += d[i].lengthSquared() / this.bodies[i].getMass();
            crossMassSum += Vec2.cross(this.bodies[i].getLinearVelocity(), d[i]);
            ++i;
        }
        float lambda = -2.0f * crossMassSum / dotMassSum;
        this.m_impulse += lambda;
        int i2 = 0;
        while (i2 < this.bodies.length) {
            this.bodies[i2].m_linearVelocity.x += this.bodies[i2].m_invMass * d[i2].y * 0.5f * lambda;
            this.bodies[i2].m_linearVelocity.y += this.bodies[i2].m_invMass * -d[i2].x * 0.5f * lambda;
            ++i2;
        }
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return 0.0f;
    }
}

