/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.jbox2d.pooling.IDynamicStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableStack<E, T extends E>
implements IDynamicStack<E> {
    private static final Logger log = LoggerFactory.getLogger(MutableStack.class);
    private T[] stack;
    private int index = 0;
    private int size;
    private final Class<T> sClass;
    private final Class<?>[] params;
    private final Object[] args;

    public MutableStack(Class<T> argClass, int argInitSize) {
        this(argClass, argInitSize, null, null);
    }

    public MutableStack(Class<T> argClass, int argInitSize, Class<?>[] argParam, Object[] argArgs) {
        this.sClass = argClass;
        this.params = argParam;
        this.args = argArgs;
        this.stack = null;
        this.index = 0;
        this.extendStack(argInitSize);
    }

    private void extendStack(int argSize) {
        Object[] newStack = (Object[])Array.newInstance(this.sClass, argSize);
        if (this.stack != null) {
            System.arraycopy(this.stack, 0, newStack, 0, this.size);
        }
        int i = 0;
        while (i < newStack.length) {
            block14: {
                try {
                    newStack[i] = this.params != null ? this.sClass.getConstructor(this.params).newInstance(this.args) : this.sClass.newInstance();
                }
                catch (InstantiationException e) {
                    log.error("Error creating pooled object " + this.sClass.getSimpleName(), (Throwable)e);
                    assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                }
                catch (IllegalAccessException e) {
                    log.error("Error creating pooled object " + this.sClass.getSimpleName(), (Throwable)e);
                    assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                }
                catch (IllegalArgumentException e) {
                    log.error("Error creating pooled object " + this.sClass.getSimpleName(), (Throwable)e);
                    assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                }
                catch (SecurityException e) {
                    log.error("Error creating pooled object " + this.sClass.getSimpleName(), (Throwable)e);
                    assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                }
                catch (InvocationTargetException e) {
                    log.error("Error creating pooled object " + this.sClass.getSimpleName(), (Throwable)e);
                    assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                }
                catch (NoSuchMethodException e) {
                    log.error("Error creating pooled object " + this.sClass.getSimpleName(), (Throwable)e);
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)("Error creating pooled object " + this.sClass.getCanonicalName()));
                }
            }
            ++i;
        }
        this.stack = newStack;
        this.size = newStack.length;
    }

    @Override
    public final E pop() {
        if (this.index >= this.size) {
            this.extendStack(this.size * 2);
        }
        return (E)this.stack[this.index++];
    }

    @Override
    public final void push(E argObject) {
        assert (this.index > 0);
        this.stack[--this.index] = argObject;
    }
}

