/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import java.util.ArrayList;
import traer.physics.Attraction;
import traer.physics.Force;
import traer.physics.Integrator;
import traer.physics.ModifiedEulerIntegrator;
import traer.physics.Particle;
import traer.physics.RungeKuttaIntegrator;
import traer.physics.Spring;
import traer.physics.Vector3D;

public class ParticleSystem {
    public static final int RUNGE_KUTTA = 0;
    public static final int MODIFIED_EULER = 1;
    protected static final float DEFAULT_GRAVITY = 0.0f;
    protected static final float DEFAULT_DRAG = 0.001f;
    ArrayList particles;
    ArrayList springs;
    ArrayList attractions;
    ArrayList customForces = new ArrayList();
    Integrator integrator = new RungeKuttaIntegrator(this);
    Vector3D gravity;
    float drag;
    boolean hasDeadParticles = false;

    public final void setIntegrator(int integrator) {
        switch (integrator) {
            case 0: {
                this.integrator = new RungeKuttaIntegrator(this);
                break;
            }
            case 1: {
                this.integrator = new ModifiedEulerIntegrator(this);
            }
        }
    }

    public final void setGravity(float x, float y, float z) {
        this.gravity.set(x, y, z);
    }

    public final void setGravity(float g) {
        this.gravity.set(0.0f, g, 0.0f);
    }

    public final void setDrag(float d) {
        this.drag = d;
    }

    public final void tick() {
        this.tick(1.0f);
    }

    public final void tick(float t) {
        this.integrator.step(t);
    }

    public final Particle makeParticle(float mass, float x, float y, float z) {
        Particle p = new Particle(mass);
        p.position().set(x, y, z);
        this.particles.add(p);
        return p;
    }

    public final Particle makeParticle() {
        return this.makeParticle(1.0f, 0.0f, 0.0f, 0.0f);
    }

    public final Spring makeSpring(Particle a, Particle b, float ks, float d, float r) {
        Spring s = new Spring(a, b, ks, d, r);
        this.springs.add(s);
        return s;
    }

    public final Attraction makeAttraction(Particle a, Particle b, float k, float minDistance) {
        Attraction m = new Attraction(a, b, k, minDistance);
        this.attractions.add(m);
        return m;
    }

    public final void clear() {
        this.particles.clear();
        this.springs.clear();
        this.attractions.clear();
    }

    public ParticleSystem(float g, float somedrag) {
        this.particles = new ArrayList();
        this.springs = new ArrayList();
        this.attractions = new ArrayList();
        this.gravity = new Vector3D(0.0f, g, 0.0f);
        this.drag = somedrag;
    }

    public ParticleSystem(float gx, float gy, float gz, float somedrag) {
        this.particles = new ArrayList();
        this.springs = new ArrayList();
        this.attractions = new ArrayList();
        this.gravity = new Vector3D(gx, gy, gz);
        this.drag = somedrag;
    }

    public ParticleSystem() {
        this.particles = new ArrayList();
        this.springs = new ArrayList();
        this.attractions = new ArrayList();
        this.gravity = new Vector3D(0.0f, 0.0f, 0.0f);
        this.drag = 0.001f;
    }

    protected final void applyForces() {
        Force f;
        Particle p;
        int i;
        if (!this.gravity.isZero()) {
            i = 0;
            while (i < this.particles.size()) {
                p = (Particle)this.particles.get(i);
                p.force.add(this.gravity);
                ++i;
            }
        }
        i = 0;
        while (i < this.particles.size()) {
            p = (Particle)this.particles.get(i);
            p.force.add(p.velocity.x() * -this.drag, p.velocity.y() * -this.drag, p.velocity.z() * -this.drag);
            ++i;
        }
        i = 0;
        while (i < this.springs.size()) {
            f = (Spring)this.springs.get(i);
            ((Spring)f).apply();
            ++i;
        }
        i = 0;
        while (i < this.attractions.size()) {
            f = (Attraction)this.attractions.get(i);
            ((Attraction)f).apply();
            ++i;
        }
        i = 0;
        while (i < this.customForces.size()) {
            f = (Force)this.customForces.get(i);
            f.apply();
            ++i;
        }
    }

    protected final void clearForces() {
        for (Particle p : this.particles) {
            p.force.clear();
        }
    }

    public final int numberOfParticles() {
        return this.particles.size();
    }

    public final int numberOfSprings() {
        return this.springs.size();
    }

    public final int numberOfAttractions() {
        return this.attractions.size();
    }

    public final Particle getParticle(int i) {
        return (Particle)this.particles.get(i);
    }

    public final Spring getSpring(int i) {
        return (Spring)this.springs.get(i);
    }

    public final Attraction getAttraction(int i) {
        return (Attraction)this.attractions.get(i);
    }

    public final void addCustomForce(Force f) {
        this.customForces.add(f);
    }

    public final int numberOfCustomForces() {
        return this.customForces.size();
    }

    public final Force getCustomForce(int i) {
        return (Force)this.customForces.get(i);
    }

    public final Force removeCustomForce(int i) {
        return (Force)this.customForces.remove(i);
    }

    public final void removeParticle(Particle p) {
        this.particles.remove(p);
    }

    public final Spring removeSpring(int i) {
        return (Spring)this.springs.remove(i);
    }

    public final Attraction removeAttraction(int i) {
        return (Attraction)this.attractions.remove(i);
    }

    public final void removeAttraction(Attraction s) {
        this.attractions.remove(s);
    }

    public final void removeSpring(Spring a) {
        this.springs.remove(a);
    }

    public final void removeCustomForce(Force f) {
        this.customForces.remove(f);
    }
}

