/*
 * Decompiled with CFR 0.152.
 */
package pbox2d;

import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import pbox2d.PContactListener;
import processing.core.PApplet;
import processing.core.PVector;

public class PBox2D {
    PApplet parent;
    public World world;
    public float transX;
    public float transY;
    public float scaleFactor;
    public float yFlip;
    Body groundBody;
    PContactListener contactlistener;

    public PBox2D(PApplet p) {
        this(p, 10.0f);
    }

    public PBox2D(PApplet p, float sf) {
        this.parent = p;
        this.transX = this.parent.width / 2;
        this.transY = this.parent.height / 2;
        this.scaleFactor = sf;
        this.yFlip = -1.0f;
    }

    public void listenForCollisions() {
        this.contactlistener = new PContactListener(this.parent);
        this.world.setContactListener((ContactListener)this.contactlistener);
    }

    public void setScaleFactor(float scale) {
        this.scaleFactor = scale;
    }

    public void step() {
        float timeStep = 0.016666668f;
        this.step(timeStep, 10, 10);
    }

    public void step(float timeStep, int velocityIterations, int positionIterations) {
        this.world.step(timeStep, velocityIterations, positionIterations);
    }

    public void setWarmStarting(boolean b) {
        this.world.setWarmStarting(b);
    }

    public void setContinuousPhysics(boolean b) {
        this.world.setContinuousPhysics(b);
    }

    public void createWorld() {
        Vec2 gravity = new Vec2(0.0f, -10.0f);
        this.createWorld(gravity, false);
        this.setWarmStarting(true);
        this.setContinuousPhysics(true);
    }

    public void createWorld(Vec2 gravity, boolean doSleep) {
        this.createWorld(gravity, doSleep, true, true);
    }

    public void createWorld(Vec2 gravity, boolean doSleep, boolean warmStarting, boolean continous) {
        this.world = new World(gravity);
        this.setWarmStarting(warmStarting);
        this.setContinuousPhysics(continous);
        BodyDef bodyDef = new BodyDef();
        this.groundBody = this.world.createBody(bodyDef);
    }

    public Body getGroundBody() {
        return this.groundBody;
    }

    public void setGravity(float x, float y) {
        this.world.setGravity(new Vec2(x, y));
    }

    public Vec2 coordWorldToPixels(Vec2 world) {
        return this.coordWorldToPixels(world.x, world.y);
    }

    public PVector coordWorldToPixelsPVector(Vec2 world) {
        Vec2 v = this.coordWorldToPixels(world.x, world.y);
        return new PVector(v.x, v.y);
    }

    public Vec2 coordWorldToPixels(float worldX, float worldY) {
        float pixelX = PApplet.map((float)worldX, (float)0.0f, (float)1.0f, (float)this.transX, (float)(this.transX + this.scaleFactor));
        float pixelY = PApplet.map((float)worldY, (float)0.0f, (float)1.0f, (float)this.transY, (float)(this.transY + this.scaleFactor));
        if (this.yFlip == -1.0f) {
            pixelY = PApplet.map((float)pixelY, (float)0.0f, (float)this.parent.height, (float)this.parent.height, (float)0.0f);
        }
        return new Vec2(pixelX, pixelY);
    }

    public Vec2 coordPixelsToWorld(Vec2 screen) {
        return this.coordPixelsToWorld(screen.x, screen.y);
    }

    public Vec2 coordPixelsToWorld(PVector screen) {
        return this.coordPixelsToWorld(screen.x, screen.y);
    }

    public Vec2 coordPixelsToWorld(float pixelX, float pixelY) {
        float worldX = PApplet.map((float)pixelX, (float)this.transX, (float)(this.transX + this.scaleFactor), (float)0.0f, (float)1.0f);
        float worldY = pixelY;
        if (this.yFlip == -1.0f) {
            worldY = PApplet.map((float)pixelY, (float)this.parent.height, (float)0.0f, (float)0.0f, (float)this.parent.height);
        }
        worldY = PApplet.map((float)worldY, (float)this.transY, (float)(this.transY + this.scaleFactor), (float)0.0f, (float)1.0f);
        return new Vec2(worldX, worldY);
    }

    public float scalarPixelsToWorld(float val) {
        return val / this.scaleFactor;
    }

    public float scalarWorldToPixels(float val) {
        return val * this.scaleFactor;
    }

    public Vec2 vectorPixelsToWorld(Vec2 v) {
        Vec2 u = new Vec2(v.x / this.scaleFactor, v.y / this.scaleFactor);
        u.y *= this.yFlip;
        return u;
    }

    public Vec2 vectorPixelsToWorld(PVector v) {
        Vec2 u = new Vec2(v.x / this.scaleFactor, v.y / this.scaleFactor);
        u.y *= this.yFlip;
        return u;
    }

    public Vec2 vectorWorldToPixels(Vec2 v) {
        Vec2 u = new Vec2(v.x * this.scaleFactor, v.y * this.scaleFactor);
        u.y *= this.yFlip;
        return u;
    }

    public PVector vectorWorldToPixelsPVector(Vec2 v) {
        PVector u = new PVector(v.x * this.scaleFactor, v.y * this.scaleFactor);
        u.y *= this.yFlip;
        return u;
    }

    public Body createBody(BodyDef bd) {
        return this.world.createBody(bd);
    }

    public Joint createJoint(JointDef jd) {
        return this.world.createJoint(jd);
    }

    public Vec2 getBodyPixelCoord(Body b) {
        Transform xf = b.getTransform();
        return this.coordWorldToPixels(xf.p);
    }

    public PVector getBodyPixelCoordPVector(Body b) {
        Transform xf = b.getTransform();
        return this.coordWorldToPixelsPVector(xf.p);
    }

    public void destroyBody(Body b) {
        this.world.destroyBody(b);
    }
}

